/*
 * Decompiled with CFR 0.152.
 */
package morph.avaritia.util;

import codechicken.lib.util.ItemUtils;
import codechicken.lib.vec.Vector3;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import morph.avaritia.handler.BlockBreakEvents;
import morph.avaritia.init.AvaritiaModContent;
import morph.avaritia.item.MatterClusterItem;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.Tags;

public class ToolHelper {
    public static Set<TagKey<Item>> DEFAULT_TRASH_TAGS = Sets.newHashSet((Object[])new TagKey[]{Tags.Items.STONE, Tags.Items.SAND, Tags.Items.GRAVEL, Tags.Items.NETHERRACK});

    public static void aoeBlocks(Player player, ItemStack stack, Level level, @Nullable BlockPos origin, BlockPos min, BlockPos max, Block target, boolean filterTrash) {
        if (!level.f_46443_) {
            BlockBreakEvents.enableItemCapture();
        }
        float originStrength = 0.0f;
        if (origin != null) {
            BlockState blockState = player.f_19853_.m_8055_(origin);
            originStrength = ToolHelper.blockStrength(blockState, player, player.f_19853_, origin);
        }
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)min, (BlockPos)max)) {
            ToolHelper.removeBlockWithDrops(player, stack, level, pos, target, originStrength);
        }
        if (!level.f_46443_) {
            BlockBreakEvents.stopItemCapture();
            Set<ItemStack> drops = BlockBreakEvents.getCapturedDrops();
            if (filterTrash) {
                drops = ToolHelper.removeTrash(stack, drops);
            }
            List<ItemStack> clusters = MatterClusterItem.makeClusters(drops);
            for (ItemStack cluster : clusters) {
                ItemUtils.dropItem((ItemStack)cluster, (Level)level, (Vector3)Vector3.fromEntityCenter((Entity)player));
            }
        }
    }

    public static void removeBlockWithDrops(Player player, ItemStack stack, Level level, BlockPos pos, Block target, float originStrength) {
        if (!level.m_46749_(pos)) {
            return;
        }
        BlockState state = level.m_8055_(pos);
        FluidState fluidState = level.m_6425_(pos);
        Block block = state.m_60734_();
        if (target != null && target != state.m_60734_() || level.m_46859_(pos)) {
            return;
        }
        if (!level.f_46443_ && block == Blocks.f_50440_ && stack.m_41720_() == AvaritiaModContent.INFINITY_AXE.get()) {
            level.m_46597_(pos, Blocks.f_50493_.m_49966_());
        }
        if (!stack.m_41735_(state)) {
            return;
        }
        float strength = ToolHelper.blockStrength(state, player, level, pos);
        if (!ForgeHooks.isCorrectToolForDrops((BlockState)state, (Player)player) || originStrength / strength > 10.0f) {
            return;
        }
        if (!level.f_46443_) {
            int xp = ForgeHooks.onBlockBreakEvent((Level)level, (GameType)((ServerPlayer)player).f_8941_.m_9290_(), (ServerPlayer)((ServerPlayer)player), (BlockPos)pos);
            if (xp == -1) {
                ServerPlayer mpPlayer = (ServerPlayer)player;
                mpPlayer.f_8906_.m_141995_((Packet)new ClientboundBlockUpdatePacket((BlockGetter)level, pos));
                return;
            }
            stack.m_41686_(level, state, pos, player);
            BlockEntity tile = level.m_7702_(pos);
            if (state.onDestroyedByPlayer(level, pos, player, true, level.m_6425_(pos))) {
                block.m_6786_((LevelAccessor)level, pos, state);
                block.m_6240_(level, player, pos, state, tile, player.m_21205_());
            }
        } else {
            if (block.onDestroyedByPlayer(state, level, pos, player, true, fluidState)) {
                block.m_6786_((LevelAccessor)level, pos, state);
            }
            stack.m_41686_(level, state, pos, player);
            if (Minecraft.m_91087_().f_91077_ instanceof BlockHitResult) {
                Minecraft.m_91087_().m_91403_().m_104955_((Packet)new ServerboundPlayerActionPacket(ServerboundPlayerActionPacket.Action.STOP_DESTROY_BLOCK, pos, ((BlockHitResult)Minecraft.m_91087_().f_91077_).m_82434_()));
            }
        }
    }

    public static float blockStrength(BlockState state, Player player, Level world, BlockPos pos) {
        float hardness = state.m_60800_((BlockGetter)world, pos);
        if (hardness < 0.0f) {
            return 0.0f;
        }
        if (!ForgeHooks.isCorrectToolForDrops((BlockState)state, (Player)player)) {
            return player.getDigSpeed(state, pos) / hardness / 100.0f;
        }
        return player.getDigSpeed(state, pos) / hardness / 30.0f;
    }

    public static Set<ItemStack> removeTrash(ItemStack holdingStack, Set<ItemStack> drops) {
        HashSet<ItemStack> trashItems = new HashSet<ItemStack>();
        for (ItemStack drop : drops) {
            if (!ToolHelper.isTrash(holdingStack, drop)) continue;
            trashItems.add(drop);
        }
        drops.removeAll(trashItems);
        return drops;
    }

    private static boolean isTrash(ItemStack holdingStack, ItemStack suspect) {
        for (TagKey<Item> tag : DEFAULT_TRASH_TAGS) {
            if (!suspect.m_204117_(tag)) continue;
            return true;
        }
        return false;
    }
}

